int PatCountFT = ...;   // Num patterns for full timers
int PatCountPT = ...;   // Num patterns for part timers
 
int TotalShifts = 28*2; 

range AllShifts = 0..TotalShifts-1;
range PatsFT = 0..PatCountFT-1;
range PatsPT = 0..PatCountPT-1;

range DayShifts = 0..27;
range NightShifts = 28..55;

int PatternsFT[PatsFT][AllShifts] = ...;  
int PatternScoresFT[PatsFT] = ...;

int PatternsPT[PatsPT][AllShifts] = ...;  
int PatternScoresPT[PatsPT] = ...;

/* Below we say each pattern can be assigned between 0 and 4
 * times but actually, every employee will have a different 
 * schedule as it is impossible for two employees to have no 
 * night shifts (28 to assign and max 4 each) and so if two 
 * employees did have the same schedule then there would be 
 * more than one night shift covered on a single day.
 */
dvar int assignFT[PatsFT] in 0..4; // 0..1
dvar int assignPT[PatsPT] in 0..4; // 0..1

minimize (
      sum (p in PatsFT) (PatternScoresFT[p] * assignFT[p])
    + sum (p in PatsPT) (PatternScoresPT[p] * assignPT[p])
);
             
subject to {
        
    // 4 FTs and 4 PTs
    sum (p in PatsFT) assignFT[p] == 4;     
    sum (p in PatsPT) assignPT[p] == 4;
      
    // Cover (3 Days, 1 Night each day)  
    forall (d in DayShifts)
        ( sum (p in PatsFT) (assignFT[p] * PatternsFT[p,d])
        + sum (p in PatsPT) (assignPT[p] * PatternsPT[p,d]) ) == 3;
        
   forall (d in NightShifts)
        ( sum (p in PatsFT) (assignFT[p] * PatternsFT[p,d])
        + sum (p in PatsPT) (assignPT[p] * PatternsPT[p,d]) ) == 1;
}  


execute {
   
   // Print out the roster for copy and pasting 
   // into RosterBooster to verify the solution.
   for(var i in PatsFT) 
   {
      
      for (var j=0; j<assignFT[i]; j++)
      {
         for (var d=0; d<28; d++)
         {
            if (PatternsFT[i][d]==1)
               write("D");

            if (PatternsFT[i][d+28]==1)
               write("N");            

            if (d+1<28) 
                write("\t");
         }
         writeln("");
      }
   }
   
   for(i in PatsPT) 
   {
      
      for (j=0; j<assignPT[i]; j++)
      {
         for (d=0; d<28; d++)
         {
            if (PatternsPT[i][d]==1)
               write("D");

            if (PatternsPT[i][d+28]==1)
               write("N");            

            if (d+1<28) 
                write("\t");
         }
         writeln("");
      }
   }

}
