int PatCount = ...;   // Num patterns 

int TotalShifts = 7*3; 

range AllShifts = 0..TotalShifts-1;
range Pats = 0..PatCount-1;

int employeeCount = 27;
range All = 0..employeeCount-1;

range AShifts = 0..6;
range PShifts = 7..13;
range NShifts = 14..20;

int Patterns[Pats][AllShifts] = ...;  
int PatternScores[All][Pats] = ...;


dvar int assign[All][Pats] in 0..1;


minimize (
      sum (e in All, p in Pats) (assign[e,p] * PatternScores[e,p])
);
             
subject to {
        
    // One pattern per person
    forall (e in All)
        sum (p in Pats) (assign[e,p]) == 1; 
 
    // Cover
    forall (d in AShifts)
        sum (e in All, p in Pats) (assign[e,p] * Patterns[p,d]) == 6;
        
    forall (d in PShifts)
        sum (e in All, p in Pats) (assign[e,p] * Patterns[p,d]) == 6;
        
    forall (d in NShifts)
        sum (e in All, p in Pats) (assign[e,p] * Patterns[p,d]) == 3;
}  


execute {
   
   // Print out the roster for copy and pasting 
   // into RosterBooster to verify the solution.
   for(var i in All) 
   {
      for (var j in Pats)
      {
         if (assign[i][j] == 1)
         { 
            for (var d=0; d<7; d++)
            {
               if (Patterns[j][d]==1)
                  write("A");
   
               if (Patterns[j][d+7]==1)
                  write("P");   
                  
               if (Patterns[j][d+14]==1)
                  write("N");          
   
               if (d+1<7) 
                   write("\t");
            }
            writeln("");
            
            break;
         }
      }
   }

}

