int PatCount = ...;   
int TotalDays = ...;  

range Days = 0..TotalDays-1;
range Pats = 0..PatCount-1;

int Patterns[Pats][Days] = ...;  
int PatternScores[Pats] = ...;

int totalEmployees = 16;

// Cover requirements
int Req[Days] = [ 
   10, 10, 10, 10, 10, 8, 8,
   10, 10, 10, 10, 10, 8, 8,
   10, 10, 10, 10, 10, 8, 8,
   10, 10, 10, 10, 10, 8, 8
   ];

dvar int assign[Pats] in 0..totalEmployees;  // Indicates a pattern assignment

minimize (
    sum (p in Pats) (PatternScores[p] * assign[p])
);
             
subject to {
        
    // Select 16 employees
    sum (p in Pats) assign[p] == totalEmployees;     
      
    // Cover   
    forall (d in Days)
        sum (p in Pats) (assign[p] * Patterns[p,d]) == Req[d];
}  

execute {
   
   // Print out the roster
   for(var i in Pats) 
   {
      
      for (var j=0; j<assign[i]; j++)
      {
         for (var d=0; d<TotalDays; d++)
         {
            if (Patterns[i][d]==1)
               write("D");
            
            if (d+1<TotalDays) 
                write("\t");
         }
         writeln("");
      }
   }

}
